<?php
/**
 * ice-cream-delights functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ice-cream-delights
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
//	define( '_S_VERSION', '1.0.0' );
	define( '_S_VERSION', rand() );
}
include_once "inc/form_validation.php";
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function ice_cream_delights_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on ice-cream-delights, use a find and replace
		* to change 'ice-cream-delights' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'ice-cream-delights', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'ice-cream-delights' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'ice_cream_delights_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'ice_cream_delights_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ice_cream_delights_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'ice_cream_delights_content_width', 640 );
}
add_action( 'after_setup_theme', 'ice_cream_delights_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ice_cream_delights_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'ice-cream-delights' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'ice-cream-delights' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'ice_cream_delights_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ice_cream_delights_scripts() {
	wp_enqueue_style( 'ice-cream-delights-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'ice-cream-delights-style', 'rtl', 'replace' );

	wp_enqueue_script( 'ice-cream-delights-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ice_cream_delights_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/* ICD */
function add_additional_class_on_nav_a($classes, $item, $args)
{
    if (isset($args->add_a_class)) {
        $classes['class'] = $args->add_a_class;
    }
    return $classes;
}
add_filter('nav_menu_link_attributes', 'add_additional_class_on_nav_a', 1, 3);

function nav_only_bg(){
	$pages=array(166);
	if(in_array(get_the_ID(),$pages)){
		echo " nav_only_bg";
	}
}
function show_footer_cta(){
	$pages=array(220);
	if(!in_array(get_the_ID(),$pages)){
		return true;
	}else{
		return false;
	}
}

function my_enqueue() {
	wp_enqueue_script( 'ajax-script', get_template_directory_uri() . '/js/scripts.js', array('jquery') );
	wp_localize_script( 'ajax-script', 'my_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
}

add_action( 'wp_enqueue_scripts', 'my_enqueue' );

function products_list($selection=false){
	$section_4 = get_field("section_4",190);
	echo '<section class="products section-holder '.(($selection)?"enable-selection":"").'">
	<div class="row">
	<div class="col-8 col-md-5 col-lg-4 vertical-center-align">
		<h2>'.$section_4[0]["title"].'</h2>
	</div>
	<div class="col-4 col-md-7 col-lg-8 ">
	<div class="tri-scoop-1 d-none d-lg-block"></div>
	</div>
	</div>
	<div class="row product-list">';
	
		$items = $section_4[0]["product_list"];
		foreach($items as $key=>$value){
			echo "<div class='col-md-4 col-lg-3 product-item'><div class='checkbox'></div><div class='content'>";
			echo "<div class='product-image'><img alt='".$value['title']."' src='".$value['image']."'/></div>";
			echo "<h4>".$value['title']."</h4>";
			echo "</div></div>";
		}
	
	if($selection){
		echo '<div class="cta-holder">
					<a class="btn btn-primary col-12 btn-large disabled submit-home-menu" href="book-your-van-now/">Book now</a>
				</div>';
	}
	echo '</div>
	</section>';
}


//REMOVE GUTENBERG BLOCK LIBRARY CSS FROM LOADING ON FRONTEND
function remove_wp_block_library_css(){
	wp_dequeue_style( 'wp-block-library' );
	wp_dequeue_style( 'wp-block-library-theme' );
	wp_dequeue_style( 'wc-block-style' ); // REMOVE WOOCOMMERCE BLOCK CSS
	wp_dequeue_style( 'global-styles' ); // REMOVE THEME.JSON
}
add_action( 'wp_enqueue_scripts', 'remove_wp_block_library_css', 100 );
add_filter( 'xmlrpc_enabled', '__return_false' );