<?php

/* FORM PROCESSING */

function validateFields($key,$value,$type,$required=true,$options){

    $input = $value[$key];

    $email_error = "Please enter a valid email";
    $number_error = "Please enter a valid number";
    $name_error = "Please enter a valid name";
    $phone_error = "Please enter a valid phone number";
    $text_error = "Please enter a valid input"; 
    $url_error = "Please enter a valid URL";
    $date_error = "Please enter a valid date";
    $country_error = "The country you have selected is invalid";
    if(isset($options['file'])){
        $file_format_error = "The supported file formats are ".implode(",",$options['file']['supported_extensions']);
    }
    $file_size_error = "The maximum allowed file size is 2MB";
    $file_not_found_error = "Please select a file to upload";

    $response=array(
        "value"=>"",
        "valid"=>true,
        "error"=>""
    );

    switch ($type) {
        case "integer":
            if($required){
              if(empty($input) || !ctype_digit($input)){
                  $response['valid']=false;
                  $response['error']=$number_error;
              }
            }else{
                if(!ctype_digit($input)){
                    $response['valid']=false;
                    $response['error']=$number_error;
                }
            }
        break;
        case "date":
            $date = $input;
            $format = 'd-m-Y';
            $d = DateTime::createFromFormat($format, $date);
            if($required){
                if(!empty($input)){
                    //print_r($d);
                    if(!empty($d)){
                        if ($d->format($format) === $date) {
                            $input = date("Y-m-d", strtotime($date));
                        }else{
                            $response['valid']=false;
                            $response['error']=$date_error;
                        }
                    }else{
                        $response['valid']=false;
                        $response['error']=$date_error;
                    }
                }else{
                    $response['valid']=false;
                    $response['error']=$date_error;
                }
            }else{
                if(!empty($d)){
                    if ($d->format($format) === $date) {
                        $input = date("Y-m-d", strtotime($date));
                    }else{
                        $response['valid']=false;
                        $response['error']=$date_error;
                    }
                }
            }
        break;
        case "email":
          if($required){
            if(empty($input) || !filter_var($input, FILTER_VALIDATE_EMAIL)){
                $response['valid']=false;
                $response['error']=$email_error;
            }
          }else{
              if(!filter_var($input, FILTER_VALIDATE_EMAIL)){
                    $response['error']=$email_error;
              }
          }
          break;

        case "plain_text":
            $input = strip_tags($input);
            if($required){
                if(empty($input)){
                    $response['valid']=false;
                    $response['error']=$text_error;
                }
            }
        break;

        case "country":
            $countries = array("Afganistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antarctica", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegowina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Congo, the Democratic Republic of the", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia (Hrvatska)", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "France Metropolitan", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard and Mc Donald Islands", "Holy See (Vatican City State)", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Iran (Islamic Republic of)", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Kyrgyzstan", "Lao, People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, The Former Yugoslav Republic of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia, Federated States of", "Moldova, Republic of", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia (Slovak Republic)", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and the South Sandwich Islands", "Spain", "Sri Lanka", "St. Helena", "St. Pierre and Miquelon", "Sudan", "Suriname", "Svalbard and Jan Mayen Islands", "Swaziland", "Sweden", "Switzerland", "Syrian Arab Republic", "Taiwan, Province of China", "Tajikistan", "Tanzania, United Republic of", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "United States Minor Outlying Islands", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands (British)", "Virgin Islands (U.S.)", "Wallis and Futuna Islands", "Western Sahara", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe");
            if($required){
                if(empty($input) || !in_array($input,$countries)){
                    $response['valid']=false;
                    $response['error']=$country_error;
                }
            }else{
                if(!in_array($input,$countries)){
                    $response['error']=$country_error;
                }
            }
        break;


        case "url":
            if($required){
                if(empty($input) || !filter_var($input, FILTER_VALIDATE_URL)){
                    $response['valid']=false;
                    $response['error']=$url_error;
                }
            }else{
                if(!filter_var($input, FILTER_VALIDATE_URL)){
                    $response['error']=$url_error;
                }
            }
        break;


        case "name":
            if($required){
                if(empty($input) || !preg_match('/^[\p{L} ]+$/u',$input)){
                    $response['valid']=false;
                    $response['error']=$name_error;
                }
            }else{
                if(!preg_match('/^[\p{L} ]+$/u',$input)){
                    $response['error']=$name_error;
                }
            }
        break;

        case "phone":
            if($required){
                if(empty($input) || !preg_match('/^(?=.*[0-9])[- +()0-9]+$/',$input)){
                    $response['valid']=false;
                    $response['error']=$phone_error;
                }
            }else{
                if(!preg_match('/^(?=.*[0-9])[- +()0-9]+$/',$input)){
                    $response['error']=$phone_error;
                }
            }
        break;



        case "file":
            $file_extension=strtolower(end(explode('.',$input['name'])));
            $file_size =$input['size'];
            if($required){
                if(isset($input)){
                    if(empty($input['name'])){
                        $response['valid']=false;
                        $response['error']=$file_not_found_error;
                    }else{
                        if(in_array($file_extension,$options['file']['supported_extensions'])=== false){
                            $response['valid']=false;
                            $response['error']=$file_format_error;
                        }
                        if($file_size > 2097152){
                            $response['valid']=false;
                            $response['error']=$file_size_error;
                        }
                    }
                }
            }else{
                if(isset($input)){
                    if(in_array($file_extension,$options['file']['supported_extensions'])=== false){
                        $response['valid']=false;
                        $response['error']=$file_format_error;
                     }
                     if($file_size > 2097152){
                        $response['valid']=false;
                        $response['error']=$file_size_error;
                     }
                }
            }

        break;
      }

      if($response['valid']){
        $response['value'] = $input;
        }
      
      // FILE UPLOAD
      if(isset($options['file']['start_upload'])){
          if($options['file']['start_upload']===true){
              $file_name = $input['name'];
              $file_tmp =$input['tmp_name'];
              $file_type=$input['type'];
              add_filter( 'upload_dir',  $options['file']['custom_dir_filter'] );
              if (!function_exists('wp_handle_upload')) {
                  require_once(ABSPATH . 'wp-admin/includes/file.php');
              }
              $file = wp_handle_upload($input,array('test_form' => false));
              if(isset($file['error'])){
                  $response['valid']=false;
                  $response['error']=$file['error'];
              }else{
                  $response['value']=$file['url'];
              }
              remove_filter( 'upload_dir',  $options['file']['custom_dir_filter'] );
          }
      }


      return $response;
}

function process_ajax_form_submit(){

    //************ FORM PROCESSING: VALIDATION STARTS ************//
    $validation_only = $_POST['validation_only'];
    $store_data = $_POST['atad_erots'];
    // GETTING FORM TYPE
    $form_type = $_POST['form_type'];
    // EMAIL TO SEND
    $email_address="orders@cateringatitsfinest.com"; 
    // RESPONSE ARRAY
    $inputs = array("valid"=>true,"email_sent"=>false,"stored"=>false,"response"=>array());
    // SEPERATING FILES TO PROCESS AFTER VALIDATION
    $files=array();
    // PREPARE FORM SPECIFIC FIELDS
    switch ($form_type) {

          case "party_order":
            $db_table_name = "party_order_list";
            $subject = "CAIF Website: Party order request";

            /* 'KEY' SHOULD MATCH WITH THE FILED NAME AND TABLE COLUMN NAME*/
            $raw_fields = array(
                array("name"=>"First name","key"=>"fname","value"=>$_POST, "type"=>"name","required"=>true),
                array("name"=>"Last name","key"=>"lname","value"=>$_POST, "type"=>"name","required"=>true),
                array("name"=>"Email","key"=>"email","value"=>$_POST, "type"=>"email","required"=>true),
                array("name"=>"Contact number","key"=>"phone","value"=>$_POST, "type"=>"phone","required"=>true),
                array("name"=>"Company","key"=>"company","value"=>$_POST, "type"=>"name","required"=>true),
                array("name"=>"Event","key"=>"event","value"=>$_POST, "type"=>"name","required"=>true),
                array("name"=>"Event date","key"=>"date_time","value"=>$_POST, "type"=>"date","required"=>true),
                array("name"=>"Address","key"=>"address","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"Suburb","key"=>"suburb","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"State","key"=>"state","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"Postcode","key"=>"postcode","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"Power available","key"=>"power_avail","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"No. Attending","key"=>"no_attending","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"No. Attending","key"=>"no_attending","value"=>$_POST, "type"=>"plain_text","required"=>true),

                array("name"=>"Date available","key"=>"date_of_delivery","value"=>$_POST, "type"=>"date","required"=>true),
                array("name"=>"Number of guests","key"=>"number_of_guests","value"=>$_POST, "type"=>"integer","required"=>true),
                array("name"=>"Type of function","key"=>"type_of_function","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"Comments","key"=>"comments","value"=>$_POST, "type"=>"plain_text","required"=>true),
                array("name"=>"Order status","key"=>"order_status","value"=>$_POST, "type"=>"plain_text","required"=>true),
            );
        break;          
            
        case "contact_form":
            $db_table_name = "party_order_list";
            $subject = "CAIF Website: Contact page request";

            /* 'KEY' SHOULD MATCH WITH THE FILED NAME AND TABLE COLUMN NAME*/
            $raw_fields = array(
                array("name"=>"Full name","key"=>"full_name","value"=>$_POST, "type"=>"name","required"=>true),
                array("name"=>"Email","key"=>"email","value"=>$_POST, "type"=>"email","required"=>true),
                array("name"=>"Phone","key"=>"phone","value"=>$_POST, "type"=>"phone","required"=>false),
                array("name"=>"Comments","key"=>"comments","value"=>$_POST, "type"=>"plain_text","required"=>true),
            );
        break;
    }
   

    // VALIDATING FIELDS
    foreach($raw_fields as $key=>$field){
        if($field['type']=="file"){
            $files[]=$field;
        }
        $response = validateFields($field['key'],$field['value'],$field['type'],$field['required'], (isset($field['options']))?$field['options']:"");
        if($response['valid']!==true){
            $inputs['valid'] = false;
        }
        $inputs["response"][]=array(
            "key"=>$field['key'],
            "name"=>$field['name'],
            "value"=>$response['value'],
            "valid"=>$response['valid'],
            "error"=>$response['error'],
        );
    }

    if(!$inputs['valid'] || $validation_only==1){
        echo json_encode($inputs);
        die();
    }

    // FILE UPLOAD: SHOULD HAPPEN ONLY IF ALL THE FIELDS ARE VALID ^
    /*foreach($files as $key=>$field){
        $response = validateFields($field['key'],$field['value'],"",$field['required'],array("file"=>array("start_upload"=>true,"custom_dir_filter"=> "resume_upload_dir")));
        foreach($inputs["response"] as $key=>$input_item){
            if($input_item['key'] == $field['key']){
                if(!empty($response['error'])){
                    $inputs["response"][$key]['value'] = "";
                    $inputs["response"][$key]['error'] = $response['error'];
                    $inputs["response"][$key]['valid'] = $response['valid'];
                    $inputs['valid'] = false;
                }else{
                    $inputs["response"][$key]['value'] = $response['value'];
                    $inputs["response"][$key]['valid'] = $response['valid'];
                }
            }
        }
    }*/

    //************ FORM PROCESSING: VALIDATION ENDS ************//

    //************ FORM PROCESSING: EMAIL TEMPLATE STARTS ************//
    foreach($inputs["response"] as $key=>$input_item){
        $email_template_header.='<th style="background: #000;color: #fff;padding: 8px 12px;font-family: verdana;font-size: 14px;">'.$input_item['name'].'</th>';
        $email_template_content .= '<td style="background: #eee; padding: 21px 35px; font-family: verdana; font-size: 14px;">'.$input_item['value'].'</td>';
    }
        $email_template="<table><thead><tr>";
        $email_template.=$email_template_header;
        $email_template.="</tr></thead>";
        $email_template.="<tbody>";
        $email_template.="<tr>";
        $email_template.=$email_template_content;
        $email_template.="</tr>";
        $email_template.="<tbody></tbody></table>";
        $inputs["email_sent"] = wp_mail($email_address, $subject, $email_template, array('Content-Type: text/html; charset=UTF-8'));
    //************ FORM PROCESSING: EMAIL TEMPLATE ENDS ************//


    //************ FORM PROCESSING: ADDING RECORD TO DB ************//
    if($store_data=="yes"){
        global $wpdb;
        $table = $db_table_name;
        $data=array();
        foreach($inputs["response"] as $key=>$value){
            $data[$value['key']]=$value['value'];
        }
        $inputs["stored"]=$wpdb->insert($table,$data);
    }else{
        $inputs["stored"]=true;
    }
   

    echo json_encode($inputs);

    
    die();
}



add_action("wp_ajax_ajax_form_submit","process_ajax_form_submit");
add_action("wp_ajax_nopriv_ajax_form_submit","process_ajax_form_submit");



/*SHORTCODES*/
add_shortcode( 'party_order_form', 'contact_form_process' );
function contact_form_process( $atts ) {
   // $atts = shortcode_atts( array(
   //     "action"=>"party_order"
   // ), $atts);


return'<form data-process-ajax-form><div><input name="form_type" value="party_order" type="hidden"/><input name="atad_erots" value="yes" type="hidden"/><input name="order_status" value="Pending payment" type="hidden"/><input name="action" value="ajax_form_submit" type="hidden"/></div><div class="form-group">
    <label>Full name</label>
    <input name="full_name" type="text" class="form-control" placeholder="Full name">
  </div>

  <div class="form-group">
    <label for="exampleInputEmail1">Email address</label>
    <input name="email" type="email" class="form-control" placeholder="Email address"><small id="emailHelp" class="form-text text-muted">We\'ll never share your email with anyone else.</small>
  </div>

  <div class="form-group">
    <label>Phone number</label>
    <input name="phone" type="tel" class="form-control" placeholder="Phone number">
  </div>

  <div class="form-group">
    <label>Delivery date</label>
    <input name="date_of_delivery" type="text" class="form-control" data-party-order-form placeholder="Select a delivery date">
  </div>

  <div class="form-group">
    <label>Number of guests</label>
    <input name="number_of_guests" type="number" class="form-control" placeholder="Number of guests">
  </div>

  <div class="form-group">
    <label>Type of function</label>
    <select name="type_of_function" id="update_field" data-others-field="1" data-target="#type_of_function" class="form-control" >
    <option value="">Please select</option>
    <option value="Wedding">Wedding</option>
    <option value="Engagement">Engagement</option>
      <option value="Buffet">Buffet</option>
      <option value="Lunch">Lunch</option>
      <option value="Morning tea">Morning tea</option>
      <option value="School event">School event</option>
      <option value="Eid">Eid</option>
      <option value="Ramadan">Ramadan</option>
      <option value="Hajj">Hajj</option>
      <option value="Bridal shower">Bridal shower</option>
      <option value="Baby shower">Baby shower</option>
      <option value="Aqiqah">Aqiqah</option>
      <option value="Community">Community</option>
      <option data-value="others" value="">Others</option>
    </select>
  </div>

  <div class="form-group" id="type_of_function">    <!--<label>Please enter the type of the function</label>-->    <input name="other_type_of_function" type="text" class="form-control" placeholder="Please enter the type of the function">
  </div>

  <div class="form-group">
    <label>Inquiries/Comments</label>
    <textarea class="form-control" name="comments"> </textarea>
  </div>

  <!--<div class="form-group form-check">
    <input type="checkbox" class="form-check-input" id="exampleCheck1">
    <label class="form-check-label" for="exampleCheck1">Check me out</label>
  </div>-->

  <button type="submit" class="button" style="margin-bottom:20px;margin-top: 30px;">Submit</button>

  <div data-process-form-success class="alert alert-success" style="display:none" role="alert">
    Thank you for your order. We\'ll get back to you soon
    </div>
    <div data-process-form-error class="alert alert-danger" style="display:none" role="alert">
     Oops! there is an issue in processing your request. Please try again or reach us at <a href="tel:0420 753 531">0420 753 531</a>
    </div>
</form>';

}



add_shortcode( 'contact_form', 'party_order_form_process' );
function party_order_form_process( $atts ) {
    //$atts = shortcode_atts( array(
   //    "action"=>"party_order"
   // ), $atts);


return'<form data-process-ajax-form><div><input name="form_type" value="contact_form" type="hidden"/><input name="atad_erots" value="no" type="hidden"/><input name="action" value="ajax_form_submit" type="hidden"/></div><div class="form-group">
    <label>Full name</label>
    <input name="full_name" type="text" class="form-control" placeholder="Full name">
  </div>

  <div class="form-group">
    <label for="exampleInputEmail1">Email address</label>
    <input name="email" type="email" class="form-control" placeholder="Email address"><small id="emailHelp" class="form-text text-muted">We\'ll never share your email with anyone else.</small>
  </div>

  <div class="form-group">
    <label>Phone number</label>
    <input name="phone" type="tel" class="form-control" placeholder="Phone number">
  </div>

  <div class="form-group">
    <label>Inquiries/Comments</label>
    <textarea class="form-control" name="comments"> </textarea>
  </div>

  <button type="submit" class="button" style="margin-bottom:20px;margin-top: 30px;">Submit</button>

  <div data-process-form-success class="alert alert-success" style="display:none" role="alert">
    Thank you for your interest. We\'ll get back to you soon
    </div>
    <div data-process-form-error class="alert alert-danger" style="display:none" role="alert">
     Oops! there is an issue in processing your request. Please try again or reach us at <a href="tel:0420 753 531">0420 753 531</a>
    </div>
</form>';

}

?>