
/*
jQuery.ajax({
    type: "post",
    dataType: "json",
    url: my_ajax_object.ajax_url,
    data: formData,
    success: function(msg){
        console.log(msg);
    }
});*/


(function( $ ) {
    $(document).ready(function(e){
        $("[data-form-wizard]").FormWizard();
    })
    
}(jQuery));



(function( $ ) {
		
	$.fn.FormWizard = function(options) {

		return this.each( function(){
			if( typeof options === 'string' ){

				var tpData = $(this).data('FormWizard');

				switch( options ){
					case 'stop':
						tpData.stop();
					break;
				}
			}else{
				new FormWizard(this, options);
			}
		});
	};

	var FormWizard = function(el, options){

		var me = this;
		me.el = $(el);
		me.el.data('FormWizard', me);

		me.init = function(){
			// Parse settings
			var settings = $.extend({
				activeStep:1
			}, options );

			me.settings = settings;
			me.content = $($(me.el.find("[data-agf-content]")[0])).find(">ul>li");
			me.steps = $($(me.el.find("[data-agf-steps]")[0])).find(">ul>li");
			me.cta_holder={
				next: $($(me.el.find("[data-agf-cta-holder]")[0]).find("[data-next]")[0]),
				prev: $($(me.el.find("[data-agf-cta-holder]")[0]).find("[data-prev]")[0]),
				finish: $($(me.el.find("[data-agf-cta-holder]")[0]).find("[data-finish]")[0])
			}
			me.index = me.settings.activeStep-1;
			me.totalSteps = me.steps.length-1;
			me.lastScreen = false;
            me.isStart = true;
			me.initActions();
			me.initSteps();
			me.initCtaHolder();
	
		};

		me.initActions = function(){
			me.cta_holder.finish.hide();
			me.cta_holder.prev.hide();
			me.content.data("valid",false);
			me.setActiveStep();
		}

		me.initSteps = function(){
			me.steps.click(function(){
				me.setIndex("set",$(this).index());
			})
		}

		me.initCtaHolder = function(){
			$(me.cta_holder.finish).click(function(){
				
			});
			$(me.cta_holder.prev).click(function(e){
				e.preventDefault();
				me.setIndex("-");
			});
			$(me.cta_holder.next).click(function(e){
				e.preventDefault();
				me.setIndex("+");
			});
		}

		me.setActiveStep = function(){
			me.content.removeClass("active").hide();
			$(me.content[me.index]).addClass("active").show();
			me.steps.removeClass("active");
			$(me.steps[me.index]).addClass("active");
			me.setActiveAction();
		}

        me.processCurrentStep = function(){
            
        }

        me.validateCurrentStep = function(form_fields,callback){
            console.log(form_fields);
            callback();
        }

		me.setActiveAction = function(){
			if(me.index > 0){
				me.cta_holder.prev.show();
			}else{
				me.cta_holder.prev.hide();
			}
			if(me.lastScreen){
				me.cta_holder.finish.show();
				me.cta_holder.next.hide();
			}else{
				me.cta_holder.finish.hide();
				me.cta_holder.next.show();
			}
		}

        me.processFormPiece=function(callback){
            //if(!me.isStart){
                var form_fields = $(me.content[me.index]).find('select, textarea, input').serialize();
                callback();
                //me.validateCurrentStep(form_fields,function(){
                //    me.processCurrentStep()
               // });
            //}
        }

		me.setIndex = function(action,value){
            //if(me.isStart){me.isStart=false}
			switch (action) {
				case "+":
					if(me.index < me.totalSteps){
						me.index = me.index+1;
					}
					break;

				case "-":
					if(me.index > 0){
						me.index = me.index-1;
					}
					break;

				case "set":
					me.index = value;
					break;
			
				default:
					break;
			}

			if(me.index == me.totalSteps){
				me.lastScreen=true;
			}else{
				if(me.lastScreen){
					me.lastScreen=false;
				}
			}

            if(action == "+"){
                me.processFormPiece(function(){
                    console.log(43543)
                    if($(me.content[me.index]).data("valid")){
                        me.setActiveStep();
                    }
                })
            }
			
		}

		me.init();
	};
}( jQuery ));


